Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function GetTickCount Lib "kernel32" () As Long
Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer
Public Declare Sub OutputDebugStr Lib "winmm.dll" (ByVal lpszOutputString As String)


Public Const WH_CALLWNDPROC = 4
Public Const WH_CALLWNDPROCRET = 12
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6

Public Const WM_QUEUESYNC = &H23

Public Const MSGF_DIALOGBOX = 0
Public Const MSGF_NEXTWINDOW = 6
Public Const MSGF_SCROLLBAR = 5
Public Const MSGF_MENU = 2

Public Const MSGF_MAINLOOP = 8      'Not used with MsgFilter Hook
Public Const MSGF_MAX = 8           'Not used with MsgFilter Hook
Public Const MSGF_MESSAGEBOX = 1    'Not used with MsgFilter Hook
Public Const MSGF_MOVE = 3          'Not used with MsgFilter Hook
Public Const MSGF_SIZE = 4          'Not used with MsgFilter Hook
Public Const MSGF_DDEMGR = &H8001   'Not used with MsgFilter Hook
Public Const MSGF_USER = 4096       'Not used with MsgFilter Hook

Public Const SC_ARRANGE = &HF110&
Public Const SC_CLOSE = &HF060&
Public Const SC_GROUP_IDENTIFIER = "+"
Public Const SC_HOTKEY = &HF150&
Public Const SC_HSCROLL = &HF080&
Public Const SC_KEYMENU = &HF100&
Public Const SC_MANAGER_CONNECT = &H1
Public Const SC_MANAGER_CREATE_SERVICE = &H2
Public Const SC_MANAGER_ENUMERATE_SERVICE = &H4
Public Const SC_MANAGER_LOCK = &H8
Public Const SC_MANAGER_MODIFY_BOOT_CONFIG = &H20
Public Const SC_MANAGER_QUERY_LOCK_STATUS = &H10
Public Const SC_MAXIMIZE = &HF030&
Public Const SC_MINIMIZE = &HF020&
Public Const SC_MOUSEMENU = &HF090&
Public Const SC_MOVE = &HF010&
Public Const SC_NEXTWINDOW = &HF040&
Public Const SC_PREVWINDOW = &HF050&
Public Const SC_RESTORE = &HF120&
Public Const SC_SCREENSAVE = &HF140&
Public Const SC_SIZE = &HF000&
Public Const SC_TASKLIST = &HF130&
Public Const SC_VSCROLL = &HF070&
Public Const SC_ICON = SC_MINIMIZE
Public Const SC_ZOOM = SC_MAXIMIZE
Public Const STANDARD_RIGHTS_REQUIRED = &HF0000
Public Const SC_MANAGER_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED Or SC_MANAGER_CONNECT Or SC_MANAGER_CREATE_SERVICE Or SC_MANAGER_ENUMERATE_SERVICE Or SC_MANAGER_LOCK Or SC_MANAGER_QUERY_LOCK_STATUS Or SC_MANAGER_MODIFY_BOOT_CONFIG)

Public Const SW_ERASE = &H4
Public Const SW_HIDE = 0
Public Const SW_INVALIDATE = &H2
Public Const SW_MAX = 10
Public Const SW_NORMAL = 1
Public Const SW_OTHERUNZOOM = 4
Public Const SW_OTHERZOOM = 2
Public Const SW_PARENTCLOSING = 1
Public Const SW_PARENTOPENING = 3
Public Const SW_MAXIMIZE = 3
Public Const SW_RESTORE = 9
Public Const SW_MINIMIZE = 6
Public Const SW_SCROLLCHILDREN = &H1
Public Const SW_SHOW = 5
Public Const SW_SHOWDEFAULT = 10
Public Const SW_SHOWMAXIMIZED = 3
Public Const SW_SHOWMINIMIZED = 2
Public Const SW_SHOWMINNOACTIVE = 7
Public Const SW_SHOWNA = 8
Public Const SW_SHOWNOACTIVATE = 4
Public Const SW_SHOWNORMAL = 1

Public Const SWP_FRAMECHANGED = &H20
Public Const SWP_DRAWFRAME = SWP_FRAMECHANGED
Public Const SWP_HIDEWINDOW = &H80
Public Const SWP_NOACTIVATE = &H10
Public Const SWP_NOCOPYBITS = &H100
Public Const SWP_NOMOVE = &H2
Public Const SWP_NOREDRAW = &H8
Public Const SWP_NOOWNERZORDER = &H200
Public Const SWP_NOREPOSITION = SWP_NOOWNERZORDER
Public Const SWP_NOSIZE = &H1
Public Const SWP_NOZORDER = &H4
Public Const SWP_SHOWWINDOW = &H40

Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4

Public Const HSHELL_ACTIVATESHELLWINDOW = 3
Public Const HSHELL_WINDOWCREATED = 1
Public Const HSHELL_WINDOWDESTROYED = 2
Public Const HSHELL_APPCOMMAND = 12
' #if(WINVER >= 0x0400)
Public Const HSHELL_WINDOWACTIVATED = 4
Public Const HSHELL_GETMINRECT = 5
Public Const HSHELL_REDRAW = 6
Public Const HSHELL_TASKMAN = 7
Public Const HSHELL_LANGUAGE = 8
' #if(_WIN32_WINNT >= 0x0500)
Public Const HSHELL_ACCESSIBILITYSTATE = 11
Public Const ACCESS_STICKYKEYS = &H1
Public Const ACCESS_FILTERKEYS = &H2
Public Const ACCESS_MOUSEKEYS = &H3

Public Const HCBT_MOVESIZE = 0
Public Const HCBT_MINMAX = 1
Public Const HCBT_QS = 2
Public Const HCBT_CREATEWND = 3
Public Const HCBT_DESTROYWND = 4
Public Const HCBT_ACTIVATE = 5
Public Const HCBT_CLICKSKIPPED = 6
Public Const HCBT_KEYSKIPPED = 7
Public Const HCBT_SYSCOMMAND = 8
Public Const HCBT_SETFOCUS = 9

Public Const VK_ESCAPE = &H1B


Private Type EVENTMSG
        message As Long
        paramL As Long
        paramH As Long
        time As Long
        hwnd As Long
End Type

Public Type DEBUGHOOKINFO
        hModuleHook As Long
        Reserved As Long
        lParam As Long
        wParam As Long
        code As Long
End Type

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Public Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

Public Type CREATESTRUCT
        lpCreateParams As Long
        hInstance As Long
        hMenu As Long
        hWndParent As Long
        cy As Long
        cx As Long
        y As Long
        x As Long
        style As Long
        lpszName As String
        lpszClass As String
        ExStyle As Long
End Type

Public Type CBT_CREATEWND
        lpcs As CREATESTRUCT
        hWndInsertAfter As Long
End Type

Public Type CBTACTIVATESTRUCT
        fMouse As Long
        hWndActive As Long
End Type

Public Type MOUSEHOOKSTRUCT
        pt As POINTAPI
        hwnd As Long
        wHitTestCode As Long
        dwExtraInfo As Long
End Type

    
Private hRecordHook As Long
Private hPlaybackHook As Long
Private MsgArray() As Long
Private StartTime As Long
Private CurrMSG As Long

Private hHook As Long
Private hKbdHook As Long
Private hDbgHook As Long

Public IsHooked As Boolean
Public IsDBGHooked As Boolean
Public IsPBHooked As Boolean



'-----------------------------
' SET MESSAGE FILTER HOOK
'-----------------------------
Public Sub SetCBTHook()
    If IsHooked Then
        MsgBox "Don't hook CBT twice or you will be unable to unhook it."
    Else
        hHook = SetWindowsHookEx(WH_CBT, AddressOf CBTProc, 0, App.ThreadID)
        hKbdHook = SetWindowsHookEx(WH_KEYBOARD, AddressOf KbdProc, 0, App.ThreadID)
        IsHooked = True
    End If
End Sub

Public Sub RemoveCBTHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hHook)
    temp = UnhookWindowsHookEx(hKbdHook)
    IsHooked = False
End Sub


Public Function CBTProc(ByVal uCode As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    If uCode >= 0 Then
        Select Case uCode
            Case HCBT_ACTIVATE
                'wParam == Specifies the handle to the window about to be activated
                'lParam == Pointer to the CBTACTIVATESTRUCT struct
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_ACTIVATE    HWND:" & Hex$(wParam) & vbNewLine
            Case HCBT_CLICKSKIPPED
                'wParam == Specifies the mouse message removed from the system message queue
                'lParam == Pointer to the MOUSEHOOKSTRUCT struct
                'Form2.Text1.Text = Form2.Text1.Text & "HCBT_CLICKSKIPPED    MouseMsg:" & hex$(wParam) & vbNewLine
            Case HCBT_CREATEWND
                'wParam == Specifies the handle to the new window
                'lParam == Pointer to the CBT_CREATEWND struct
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_CREATEWND    NEW_HWND:" & Hex$(wParam) & "    lParam:" & Hex$(lParam) & vbNewLine
                Exit Function 'Otherwise a GPF occurs in the CallNextHookEx function
            Case HCBT_DESTROYWND
                'wParam == Specifies the handle to the window about to be destroyed
                'lParam == 0
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_DESTROYWND    Destroyed_HWND:" & Hex$(wParam) & vbNewLine
            Case HCBT_KEYSKIPPED
                'wParam == Specifies the virtual-key code
                'lParam == Specifies the repeat count, scan code, key-transition code, previous key state, and context code
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_KEYSKIPPED    Virtual-Key Code:" & Hex$(wParam) & "    Misc_Params:" & Hex$(lParam) & vbNewLine
    
                If wParam = VK_ESCAPE And (lParam And &H80000000) Then
                    Call SetPlaybackHook
                End If
            Case HCBT_MINMAX
                'wParam == Specifies the handle to the window being minimized or maximized
                'lParam == Specifies, in the low-order word, a show-window value (SW_) specifying the operation,
                '          The high order word is undefined
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_MINMAX    HWND:" & Hex$(wParam) & "    lParam:" & Hex$((&HFFFF And lParam)) & vbNewLine
            Case HCBT_MOVESIZE
                'wParam == Specifies the handle to the window to be moved or sized
                'lParam == Pointer to a RECT struct
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_MOVESIZE    HWND:" & Hex$(wParam) & vbNewLine
            Case HCBT_QS
                'wParam == 0
                'lParam == 0
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_QS" & vbNewLine
            Case HCBT_SETFOCUS
                'wParam == Specifies the handle to the window gaining the keyboard focus
                'lParam == Specifies the handle to the window losing the keyboard focus
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_SETFOCUS    New_HWND:" & Hex$(wParam) & "    Old_HWND:" & Hex$(lParam) & vbNewLine
            Case HCBT_SYSCOMMAND
                'wParam == Specifies a system-command value (SC_*) specifying the system command
                'lParam == Contains the same data as the lParam value of a WM_SYSCOMMAND message
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_SYSCOMMAND    System_Command:" & Hex$(wParam) & "    lParam:" & Hex$(lParam) & vbNewLine
        End Select
    End If
    
    If uCode = HCBT_MOVESIZE Then
        CBTProc = 1
    Else
        CBTProc = CallNextHookEx(hHook, uCode, wParam, lParam)
    End If
End Function


Public Function KbdProc(ByVal uCode As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    KbdProc = CallNextHookEx(hKbdHook, uCode, wParam, lParam)
End Function




'-----------------------------
' SET DEBUG FILTER HOOK
'-----------------------------
Public Sub SetDebugHook()
    If IsDBGHooked Then
        MsgBox "Don't hook WH_DEBUG twice or you will be unable to unhook it."
    Else
        hDbgHook = SetWindowsHookEx(WH_DEBUG, AddressOf DebugProc, 0, App.ThreadID)
        IsDBGHooked = True
    End If
End Sub

Public Sub RemoveDebugHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hDbgHook)
    IsDBGHooked = False
End Sub


Public Function DebugProc(ByVal uCode As Long, ByVal wParam As Long, lParam As DEBUGHOOKINFO) As Long
    
    'If nCode is HC_ACTION, the hook procedure must process the message
    
    If uCode < 0 Then
        DebugProc = CallNextHookEx(hDbgHook, uCode, wParam, lParam)
    Else
        Select Case wParam
            Case WH_CBT
                Form2.Text1.Text = Form2.Text1.Text & "WH_CBT    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_JOURNALPLAYBACK
                Form2.Text1.Text = Form2.Text1.Text & "WH_JOURNALPLAYBACK    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_JOURNALRECORD
                Form2.Text1.Text = Form2.Text1.Text & "WH_JOURNALRECORD" & vbNewLine
            Case WH_KEYBOARD
                Form2.Text1.Text = Form2.Text1.Text & "WH_KEYBOARD    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_MOUSE
                Form2.Text1.Text = Form2.Text1.Text & "WH_MOUSE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
        End Select
            
        'To prevent the system from calling the hook, the hook procedure must return a nonzero value
        DebugProc = CallNextHookEx(hDbgHook, uCode, wParam, lParam)
    End If
End Function






'-----------------------------
' JOURNAL PLAYBACK
'-----------------------------
Public Sub Init()
    ReDim MsgArray(6, 10) As Long

    'WM_QUEUESYNC
    MsgArray(0, 0) = 0
    MsgArray(1, 0) = WM_QUEUESYNC
    MsgArray(2, 0) = Form2.hwnd
    MsgArray(3, 0) = 0
    MsgArray(4, 0) = 0
    MsgArray(5, 0) = 0
        
    'T
    MsgArray(0, 1) = 0
    MsgArray(1, 1) = 256
    MsgArray(2, 1) = Form2.hwnd
    MsgArray(3, 1) = 1
    MsgArray(4, 1) = 5204
    MsgArray(5, 1) = 1152

    MsgArray(0, 2) = 0
    MsgArray(1, 2) = 257
    MsgArray(2, 2) = Form2.hwnd
    MsgArray(3, 2) = 1
    MsgArray(4, 2) = 5204
    MsgArray(5, 2) = 1251
    
    'E
    MsgArray(0, 3) = 0
    MsgArray(1, 3) = 256
    MsgArray(2, 3) = Form2.hwnd
    MsgArray(3, 3) = 1
    MsgArray(4, 3) = 4677
    MsgArray(5, 3) = 1501

    MsgArray(0, 4) = 0
    MsgArray(1, 4) = 257
    MsgArray(2, 4) = Form2.hwnd
    MsgArray(3, 4) = 1
    MsgArray(4, 4) = 4677
    MsgArray(5, 4) = 1589
    
    'S
    MsgArray(0, 5) = 0
    MsgArray(1, 5) = 256
    MsgArray(2, 5) = Form2.hwnd
    MsgArray(3, 5) = 1
    MsgArray(4, 5) = 8019
    MsgArray(5, 5) = 1834
    
    MsgArray(0, 6) = 0
    MsgArray(1, 6) = 257
    MsgArray(2, 6) = Form2.hwnd
    MsgArray(3, 6) = 1
    MsgArray(4, 6) = 8019
    MsgArray(5, 6) = 1898
    
    'T
    MsgArray(0, 7) = 0
    MsgArray(1, 7) = 256
    MsgArray(2, 7) = Form2.hwnd
    MsgArray(3, 7) = 1
    MsgArray(4, 7) = 5204
    MsgArray(5, 7) = 2252
    
    MsgArray(0, 8) = 0
    MsgArray(1, 8) = 257
    MsgArray(2, 8) = Form2.hwnd
    MsgArray(3, 8) = 1
    MsgArray(4, 8) = 5204
    MsgArray(5, 8) = 2351
    
    'WM_QUEUESYNC
    MsgArray(0, 9) = 0
    MsgArray(1, 9) = WM_QUEUESYNC
    MsgArray(2, 9) = Form2.hwnd
    MsgArray(3, 9) = 0
    MsgArray(4, 9) = 0
    MsgArray(5, 9) = 2451
End Sub

Public Sub SetPlaybackHook()
    If IsPBHooked Then
        MsgBox "Don't hook journal playback twice without unhooking or you will be unable to remove the hook."
    Else
        StartTime = GetTickCount
        CurrMSG = 0
        hPlaybackHook = SetWindowsHookEx(WH_JOURNALPLAYBACK, AddressOf JournalPlaybackProc, App.hInstance, 0)
        IsPBHooked = True
    End If
End Sub

Public Sub RemovePlaybackHook()
    Dim lRetVal As Long
    lRetVal = UnhookWindowsHookEx(hPlaybackHook)
    IsPBHooked = False
End Sub


Public Function JournalPlaybackProc(ByVal uCode As Long, ByVal wParam As Long, lParam As EVENTMSG) As Long
    If uCode = HC_GETNEXT Then       'You should play the current message
        If CurrMSG >= 10 Then
            'No more messages to play, remove the hook and restore control to the user gracefully
            Call RemovePlaybackHook
        Else
            lParam.message = MsgArray(1, CurrMSG)
            lParam.hwnd = MsgArray(2, CurrMSG)
            lParam.paramH = MsgArray(3, CurrMSG)
            lParam.paramL = MsgArray(4, CurrMSG)
            If CurrMSG = 0 Then
                lParam.time = MsgArray(5, CurrMSG)
                JournalPlaybackProc = MsgArray(5, CurrMSG)
            Else
                lParam.time = MsgArray(5, CurrMSG) - MsgArray(5, CurrMSG - 1)  'StartTime + MsgArray(5, CurrMSG)
                JournalPlaybackProc = MsgArray(5, CurrMSG) - MsgArray(5, CurrMSG - 1)
            End If
        End If
    ElseIf uCode = HC_SKIP Then      'You should retrieve the next message
        If CurrMSG >= 10 Then
            'No more messages to play, remove the hook and restore control to the user gracefully
            Call RemovePlaybackHook
        End If

        CurrMSG = CurrMSG + 1
    ElseIf uCode = HC_NOREMOVE Then
        'Skip Playback - an app has called PeekMessage.
    ElseIf uCode = HC_SYSMODALON Then
        'Skip playback
    ElseIf uCode = HC_SYSMODALOFF Then
        'Skip playback
    End If
    
    JournalPlaybackProc = CallNextHookEx(hPlaybackHook, uCode, wParam, lParam)
End Function

